/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge;

import com.ibm.hwmca.fw.bridge.ServiceRequest;
import com.ibm.hwmca.fw.bridge.request.ReqCallBooleanMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallByteMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallCharMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallDoubleMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallFloatMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallIntMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallLongMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallObjectMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallShortMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCallVoidMethod;
import com.ibm.hwmca.fw.bridge.request.ReqCreateArray;
import com.ibm.hwmca.fw.bridge.request.ReqCreateNamedArray;
import com.ibm.hwmca.fw.bridge.request.ReqCreateNamedStringFromEBCDIC;
import com.ibm.hwmca.fw.bridge.request.ReqCreateNamedStringFromUTF8;
import com.ibm.hwmca.fw.bridge.request.ReqCreateStringFromEBCDIC;
import com.ibm.hwmca.fw.bridge.request.ReqCreateStringFromUTF8;
import com.ibm.hwmca.fw.bridge.request.ReqGetArrayLength;
import com.ibm.hwmca.fw.bridge.request.ReqGetBooleanArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetBooleanField;
import com.ibm.hwmca.fw.bridge.request.ReqGetByteArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetByteField;
import com.ibm.hwmca.fw.bridge.request.ReqGetCharArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetCharField;
import com.ibm.hwmca.fw.bridge.request.ReqGetDoubleArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetDoubleField;
import com.ibm.hwmca.fw.bridge.request.ReqGetFloatArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetFloatField;
import com.ibm.hwmca.fw.bridge.request.ReqGetIntArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetIntField;
import com.ibm.hwmca.fw.bridge.request.ReqGetLongArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetLongField;
import com.ibm.hwmca.fw.bridge.request.ReqGetObjectArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetObjectField;
import com.ibm.hwmca.fw.bridge.request.ReqGetShortArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqGetShortField;
import com.ibm.hwmca.fw.bridge.request.ReqGetStringAsEBCDIC;
import com.ibm.hwmca.fw.bridge.request.ReqGetStringAsUTF8;
import com.ibm.hwmca.fw.bridge.request.ReqInstantiateObject;
import com.ibm.hwmca.fw.bridge.request.ReqReleaseObjectReference;
import com.ibm.hwmca.fw.bridge.request.ReqSetBooleanArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetBooleanField;
import com.ibm.hwmca.fw.bridge.request.ReqSetByteArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetByteField;
import com.ibm.hwmca.fw.bridge.request.ReqSetCharArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetCharField;
import com.ibm.hwmca.fw.bridge.request.ReqSetDoubleArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetDoubleField;
import com.ibm.hwmca.fw.bridge.request.ReqSetFloatArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetFloatField;
import com.ibm.hwmca.fw.bridge.request.ReqSetIntArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetIntField;
import com.ibm.hwmca.fw.bridge.request.ReqSetLongArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetLongField;
import com.ibm.hwmca.fw.bridge.request.ReqSetObjectArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetObjectField;
import com.ibm.hwmca.fw.bridge.request.ReqSetShortArrayElement;
import com.ibm.hwmca.fw.bridge.request.ReqSetShortField;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public abstract class IncomingServiceRequest
extends ServiceRequest {
    private static final String TRACE_MASKT = "XNBRJIRT";

    public static IncomingServiceRequest createRequest(int code) {
        switch (code) {
            case 1: {
                return new ReqGetIntField();
            }
            case 2: {
                return new ReqGetBooleanField();
            }
            case 3: {
                return new ReqGetByteField();
            }
            case 4: {
                return new ReqGetCharField();
            }
            case 5: {
                return new ReqGetShortField();
            }
            case 6: {
                return new ReqGetLongField();
            }
            case 7: {
                return new ReqGetFloatField();
            }
            case 8: {
                return new ReqGetDoubleField();
            }
            case 9: {
                return new ReqGetObjectField();
            }
            case 10: {
                return new ReqSetIntField();
            }
            case 11: {
                return new ReqSetBooleanField();
            }
            case 12: {
                return new ReqSetByteField();
            }
            case 13: {
                return new ReqSetCharField();
            }
            case 14: {
                return new ReqSetShortField();
            }
            case 15: {
                return new ReqSetLongField();
            }
            case 16: {
                return new ReqSetFloatField();
            }
            case 17: {
                return new ReqSetDoubleField();
            }
            case 18: {
                return new ReqSetObjectField();
            }
            case 20: {
                return new ReqCallIntMethod();
            }
            case 21: {
                return new ReqCallBooleanMethod();
            }
            case 22: {
                return new ReqCallByteMethod();
            }
            case 23: {
                return new ReqCallCharMethod();
            }
            case 24: {
                return new ReqCallShortMethod();
            }
            case 25: {
                return new ReqCallLongMethod();
            }
            case 26: {
                return new ReqCallFloatMethod();
            }
            case 27: {
                return new ReqCallDoubleMethod();
            }
            case 28: {
                return new ReqCallObjectMethod();
            }
            case 29: {
                return new ReqCallVoidMethod();
            }
            case 30: {
                return new ReqGetIntArrayElement();
            }
            case 31: {
                return new ReqGetBooleanArrayElement();
            }
            case 32: {
                return new ReqGetByteArrayElement();
            }
            case 33: {
                return new ReqGetCharArrayElement();
            }
            case 34: {
                return new ReqGetShortArrayElement();
            }
            case 35: {
                return new ReqGetLongArrayElement();
            }
            case 36: {
                return new ReqGetFloatArrayElement();
            }
            case 37: {
                return new ReqGetDoubleArrayElement();
            }
            case 38: {
                return new ReqGetObjectArrayElement();
            }
            case 40: {
                return new ReqSetIntArrayElement();
            }
            case 41: {
                return new ReqSetBooleanArrayElement();
            }
            case 42: {
                return new ReqSetByteArrayElement();
            }
            case 43: {
                return new ReqSetCharArrayElement();
            }
            case 44: {
                return new ReqSetShortArrayElement();
            }
            case 45: {
                return new ReqSetLongArrayElement();
            }
            case 46: {
                return new ReqSetFloatArrayElement();
            }
            case 47: {
                return new ReqSetDoubleArrayElement();
            }
            case 48: {
                return new ReqSetObjectArrayElement();
            }
            case 50: {
                return new ReqGetStringAsUTF8();
            }
            case 51: {
                return new ReqGetStringAsEBCDIC();
            }
            case 52: {
                return new ReqCreateNamedStringFromUTF8();
            }
            case 53: {
                return new ReqCreateStringFromUTF8();
            }
            case 54: {
                return new ReqCreateNamedStringFromEBCDIC();
            }
            case 55: {
                return new ReqCreateStringFromEBCDIC();
            }
            case 60: {
                return new ReqCreateNamedArray();
            }
            case 61: {
                return new ReqCreateArray();
            }
            case 62: {
                return new ReqGetArrayLength();
            }
            case 70: {
                return new ReqReleaseObjectReference();
            }
            case 71: {
                return new ReqInstantiateObject();
            }
        }
        return null;
    }

    protected Object lookupRegisteredObject(String name) throws IOException {
        Object target = this.bridge.lookupRegisteredObject(name);
        if (target == null) {
            this.sendError(1, name);
        }
        return target;
    }

    protected String getNameForObject(Object object) {
        if (object == null) {
            return "null";
        }
        return this.bridge.registerObject(object);
    }

    protected void sendSuccess() throws IOException {
        Trace.trace(TRACE_MASKT, "Responding with success response code (to request id==" + this.requestId + ")");
        this.out.writeByte(2);
        this.out.writeInt(this.requestId);
        this.out.writeInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(int code, String error) throws IOException {
        Object object = this.getWriteLock();
        synchronized (object) {
            Trace.trace(TRACE_MASKT, "Responding with failure response (to request id==" + this.requestId + ") code " + code + ": " + error);
            this.out.writeByte(2);
            this.out.writeInt(this.requestId);
            this.out.writeInt(code);
            this.out.writeUTF(error);
            this.out.flush();
        }
    }

    public boolean isRequestQuick() {
        return true;
    }

    public abstract void readRequest() throws IOException;

    public abstract void executeRequest() throws IOException;
}

